package net.odoframework.sql.util.extensions

import net.odoframework.sql.util.schema.ManyToOneBuilder
import net.odoframework.sql.util.schema.OneToManyBuilder
import net.odoframework.sql.util.schema.OneToOneBuilder
import net.odoframework.sql.util.schema.TableBuilder
import kotlin.reflect.KClass

class TableBuilderKt<T : Any>(name:String, type: KClass<T>) : TableBuilder<T>(name, type.java) {

    inline fun <reified K : Any> oneToMany(builder: OneToManyBuilder<T, K>.() -> Unit): TableBuilder<*> {
        val oneToMany = oneToMany(K::class.java)
        oneToMany.builder()
        oneToMany.create()
        return this
    }

    inline fun <reified K : Any> manyToOne(builder: ManyToOneBuilder<T, K>.() -> Unit): TableBuilder<T> {
        val oneToMany = manyToOne(K::class.java)
        oneToMany.builder()
        oneToMany.create()
        return this
    }

    inline fun <reified K : Any> oneToOne(builder: OneToOneBuilder<T, K>.() -> Unit): TableBuilder<T> {
        val oneToMany = oneToOne(K::class.java)
        oneToMany.builder()
        oneToMany.create()
        return this
    }
}