package net.odoframework.sql.util.extensions

import net.odoframework.container.ModuleBuilder
import net.odoframework.container.injection.BeanDefinition
import net.odoframework.kt.extensions.Converter
import net.odoframework.sql.util.Key
import net.odoframework.sql.util.schema.*
import kotlin.reflect.KClass


inline fun <reified T : Any> Key.value(property: String, defaultValue: T? = null): T {
    return Converter.convert<T>(this[property], defaultValue)
        ?: throw IllegalArgumentException("$property not found in key")
}


fun schema(name: String? = null, builder: Schema.() -> Unit): Schema {
    val schema = if (name != null) SchemaBuilder.schema(name) else SchemaBuilder.schema();
    schema.builder()
    return schema;
}


operator fun <T : Runnable> ModuleBuilder.plus(beanDefinition: BeanDefinition<T>) {
    addStartupBean(beanDefinition)
}

fun <T : Any,K : Any, Z : Any> TableBuilder<T>.column(
    type: KClass<K>,
    target: KClass<Z>,
    init: ColumnBuilder<T, K, Z>.() -> Unit
): TableBuilder<T> {
    val property = this.column<K,Z>();
    property.init()
    property.create()
    return this;
}

fun <T : Any, K : Any, Z : Any> TableBuilder<T>.primaryKey(
    name: String,
    init: ColumnKt<T, K, Z>.() -> Unit
): TableBuilder<T> {
    val property = ColumnKt<T, K, Z>(name);
    property.init()
    this.column(property.build())
    return this
}

inline fun <reified T : Any> Schema.table(name: String, table: TableBuilderKt<T>.() -> Unit) :TableBuilderKt<T> {
    val tableBuilder = TableBuilderKt(name, T::class)
    tableBuilder.table()
    add(tableBuilder.build())
    return tableBuilder;
}
