/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.odoframework.container.util.Json;
import net.odoframework.jetty.runtime.DefaultExceptionHandler;
import net.odoframework.jetty.runtime.HttpServletWebRequestConverter;
import net.odoframework.jetty.runtime.HttpServletWebResponseConverter;
import net.odoframework.jetty.runtime.ServletInvocationContext;
import net.odoframework.service.ExceptionHandler;
import net.odoframework.service.InvocationContext;
import net.odoframework.service.ProviderRuntime;
import net.odoframework.service.RequestConverter;
import net.odoframework.service.ResponseConverter;
import net.odoframework.util.Pair;

public class JettyProviderRuntime
implements ProviderRuntime<Pair<HttpServletRequest, HttpServletResponse>> {
    private Json json;

    public JettyProviderRuntime(Json json) {
        this.json = json;
    }

    public RequestConverter<?, ?, Pair<HttpServletRequest, HttpServletResponse>> getProviderDefaultRequestConverter() {
        return new HttpServletWebRequestConverter(this.json);
    }

    public ResponseConverter<?, HttpServletResponse, Pair<HttpServletRequest, HttpServletResponse>> getProviderDefaultResponseConverter() {
        return new HttpServletWebResponseConverter();
    }

    public ExceptionHandler<Pair<HttpServletRequest, HttpServletResponse>, HttpServletResponse> getProviderDefaultExceptionHandler() {
        return new DefaultExceptionHandler();
    }

    public InvocationContext<Pair<HttpServletRequest, HttpServletResponse>> createInvocation(Pair<HttpServletRequest, HttpServletResponse> containerInstance) {
        return new ServletInvocationContext((HttpServletRequest)containerInstance.getLeft(), (HttpServletResponse)containerInstance.getRight());
    }
}

