/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import net.odoframework.service.ExceptionHandler;
import net.odoframework.service.InvocationContext;
import net.odoframework.util.Exceptions;
import net.odoframework.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionHandler
implements ExceptionHandler<Pair<HttpServletRequest, HttpServletResponse>, HttpServletResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    public HttpServletResponse apply(InvocationContext<Pair<HttpServletRequest, HttpServletResponse>> runtimeContext, Throwable throwable) {
        HttpServletResponse response = (HttpServletResponse)((Pair)runtimeContext.getRequestContext()).getRight();
        try {
            PrintWriter writer = response.getWriter();
            writer.write(Exceptions.toString((Throwable)throwable));
            writer.flush();
            response.sendError(500, Exceptions.toString((Throwable)throwable));
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }
}

