/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import net.odoframework.service.InvocationContext;
import net.odoframework.util.Pair;

public class ServletInvocationContext
implements InvocationContext<Pair<HttpServletRequest, HttpServletResponse>> {
    private Pair<HttpServletRequest, HttpServletResponse> context;
    private String id;

    public ServletInvocationContext(HttpServletRequest request, HttpServletResponse response) {
        this.context = Pair.cons((Object)request, (Object)response);
        this.id = String.join((CharSequence)":", request.getRequestURI(), UUID.randomUUID().toString());
    }

    public String getRequestId() {
        return this.id;
    }

    public Pair<HttpServletRequest, HttpServletResponse> getRequestContext() {
        return this.context;
    }

    public Object getRawPayload() {
        return this.context.getLeft();
    }
}

