/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.inject.Provider;
import jakarta.servlet.Servlet;
import java.util.Objects;
import java.util.Optional;
import net.odoframework.container.Application;
import net.odoframework.container.injection.Container;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements Runnable {
    private static Logger LOG = LoggerFactory.getLogger((String)JettyServer.class.getName());
    private Server server;
    private Provider<Servlet> routerServlet;
    private ThreadPool threadPool;
    private int port;
    private Optional<SslContextFactory.Server> ssl;

    public JettyServer(Provider<Servlet> routerServlet, int port, ThreadPool threadPool, Optional<SslContextFactory.Server> ssl) {
        this.routerServlet = Objects.requireNonNull(routerServlet);
        if (port < 0) {
            throw new IllegalArgumentException("port and threadPoolSize must be greater than 0");
        }
        this.port = port;
        this.threadPool = Objects.requireNonNull(threadPool);
        this.ssl = ssl;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }));
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            String className = args[0].trim();
            Class<?> applicationClass = Class.forName(className);
            Application application = (Application)applicationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            LOG.info("** STARTED APPLICATION " + applicationClass.getName());
        } else {
            Container.getModuleContainer();
            LOG.info("** STARTED APPLICATION ");
        }
    }

    public void start() {
        this.server = new Server(this.threadPool);
        ServerConnector connector = this.ssl.map(it -> new ServerConnector(this.server, it)).orElse(new ServerConnector(this.server));
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addServletWithMapping(new ServletHolder((Servlet)this.routerServlet.get()), "/*");
        this.server.setHandler((Handler)servletHandler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            try {
                if (this.server.isFailed()) {
                    this.server.stop();
                    this.server.join();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void run() {
        this.start();
    }
}

