/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.inject.Provider;
import jakarta.servlet.Servlet;
import java.util.function.Consumer;
import net.odoframework.container.ModuleBuilder;
import net.odoframework.container.Ref;
import net.odoframework.container.events.EventPublisher;
import net.odoframework.container.events.Log;
import net.odoframework.container.injection.Conditions;
import net.odoframework.container.injection.Container;
import net.odoframework.container.util.Json;
import net.odoframework.jetty.runtime.JettyLogger;
import net.odoframework.jetty.runtime.JettyProviderRuntime;
import net.odoframework.jetty.runtime.JettyServer;
import net.odoframework.jetty.runtime.RouterServlet;
import net.odoframework.service.ProviderRuntime;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyModule
extends ModuleBuilder {
    public static final String ODO_JETTY_SSL_KEYSTORE = "odo.jetty.ssl.keystore";

    public void build() {
        this.provides(SslContextFactory.Server.class).with(SslContextFactory.Server::new).set(Ref.value((String)ODO_JETTY_SSL_KEYSTORE), SslContextFactory::setKeyStorePath).set(Ref.value((String)"odo.jetty.ssl.keystore.password", (String)"changeit"), SslContextFactory::setKeyStorePassword).set(Ref.value((String)"odo.jetty.ssl.truststore"), SslContextFactory::setTrustStorePath).set(Ref.value((String)"odo.jetty.ssl.truststore.password"), SslContextFactory::setTrustStorePassword).condition(Conditions.isConfigPresent((String)ODO_JETTY_SSL_KEYSTORE));
        this.provides(Servlet.class).with(RouterServlet::new);
        this.provides(ThreadPool.class).with(it -> new QueuedThreadPool(it.valueAsInt("odo.jetty.maxthreads", 100), it.valueAsInt("odo.jetty.minthreads", 10), it.valueAsInt("odo.jetty.idletimeout", 120)));
        this.provides(ProviderRuntime.class).with(it -> new JettyProviderRuntime((Json)it.references(Json.class)));
        int defaultPort = this.getContainer().getValue(ODO_JETTY_SSL_KEYSTORE).map(it -> 8443).orElse(8080);
        this.addStartupBean(this.provides(JettyServer.class).with(it -> new JettyServer((Provider<Servlet>)it.lazyReference(Servlet.class), it.valueAsInt("odo.jetty.port", defaultPort), (ThreadPool)it.references(ThreadPool.class), it.getContainer().resolve(SslContextFactory.Server.class))));
    }

    private void postContainerCreated(Container container) {
    }

    static {
        EventPublisher.handler(Log.class, (Consumer)new JettyLogger());
    }
}

