/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.odoframework.container.util.Json;
import net.odoframework.service.web.URNPath;
import net.odoframework.service.web.WebRequest;
import net.odoframework.util.Strings;

public class HttpServletWebRequest
implements WebRequest {
    private HttpServletRequest request;
    private Json json;
    private String body;
    private Map<String, String> pathVariables;

    public HttpServletWebRequest(HttpServletRequest request, Json json) {
        this.request = request;
        this.json = json;
    }

    public String getBody() {
        if (this.body == null) {
            StringWriter stringWriter = new StringWriter();
            try {
                this.request.getReader().transferTo(stringWriter);
                this.body = stringWriter.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.body;
    }

    public <T> T getBody(Class<T> type) {
        return (T)this.json.unmarshal(this.getBody(), type);
    }

    public Optional<List<String>> getMultiValueHeader(String name) {
        String header = this.request.getHeader(name);
        if (Strings.isBlank((String)header)) {
            return Optional.empty();
        }
        if (!header.contains(",")) {
            return Optional.empty();
        }
        return Optional.of(Arrays.stream(header.split(",")).map(String::trim).collect(Collectors.toList()));
    }

    public Optional<Principal> getUserPrincipal() {
        return Optional.ofNullable(this.request.getUserPrincipal());
    }

    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.request.getHeader(name));
    }

    public String getPath() {
        return this.request.getPathInfo();
    }

    public Optional<String> getPathVariable(String name) {
        if (this.pathVariablesNotSet()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.pathVariables.get(name));
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Optional<String> getQueryParam(String name) {
        return Arrays.stream(this.request.getQueryString().split("&")).map(it -> it.split("=")).filter(it -> Objects.equals(name, it[0].trim())).map(it -> it[1].trim()).findFirst();
    }

    public Optional<List<String>> getMultiValueQueryParam(String name) {
        List result = Arrays.stream(this.request.getQueryString().split("&")).map(it -> it.split("=")).filter(it -> Objects.equals(name, it[0].trim())).map(it -> it[1].trim()).collect(Collectors.toList());
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public Json getJson() {
        return this.json;
    }

    public boolean matches(String pattern) {
        Optional pathVariables = URNPath.match((String)this.getPath(), (String)pattern);
        if (this.pathVariablesNotSet() && pathVariables.isPresent()) {
            this.pathVariables = (Map)pathVariables.get();
            return true;
        }
        return false;
    }

    public boolean pathVariablesNotSet() {
        return this.pathVariables == null || this.pathVariables.isEmpty();
    }
}

