/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import java.util.function.Consumer;
import net.odoframework.container.events.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JettyLogger
implements Consumer<Log> {
    public Level getLevel(Log log) {
        switch (log.getLevel()) {
            case trace: {
                return Level.TRACE;
            }
            case debug: {
                return Level.DEBUG;
            }
            case info: {
                return Level.INFO;
            }
            case error: {
                return Level.ERROR;
            }
            case warn: {
                return Level.WARN;
            }
            case off: {
                return Level.OFF;
            }
        }
        return Level.OFF;
    }

    @Override
    public void accept(Log log) {
        Logger logger = LogManager.getLogger((String)log.getLoggerName());
        if (log.getError() != null) {
            logger.error(log.getMessageAsString(), log.getError());
        } else {
            logger.log(this.getLevel(log), log.getMessageAsString());
        }
    }
}

