/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.odoframework.service.InvocationContext;
import net.odoframework.service.ResponseConverter;
import net.odoframework.service.web.WebResponse;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

public class HttpServletWebResponseConverter
implements ResponseConverter<WebResponse, HttpServletResponse, Pair<HttpServletRequest, HttpServletResponse>> {
    public HttpServletResponse encode(WebResponse response, InvocationContext<Pair<HttpServletRequest, HttpServletResponse>> context) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)((Pair)context.getRequestContext()).getRight();
        httpServletResponse.setStatus(response.getStatusCode());
        httpServletResponse.setHeader("x-odo-request-id", context.getRequestId());
        response.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
        response.getContentType().ifPresent(arg_0 -> ((HttpServletResponse)httpServletResponse).setContentType(arg_0));
        if (Strings.isNotBlank((String)response.getBody())) {
            httpServletResponse.setContentLength(response.getBody().length());
            try {
                httpServletResponse.getWriter().write(response.getBody());
                httpServletResponse.getWriter().flush();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return httpServletResponse;
    }
}

