/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.odoframework.container.util.Json;
import net.odoframework.jetty.runtime.HttpServletWebResponseConverter;
import net.odoframework.service.InvocationContext;
import net.odoframework.service.ResponseConverter;
import net.odoframework.service.web.SimpleWebResponse;
import net.odoframework.service.web.WebResponse;
import net.odoframework.util.Pair;

public class DefaultResponseConverter
implements ResponseConverter<Object, HttpServletResponse, Pair<HttpServletRequest, HttpServletResponse>> {
    private HttpServletWebResponseConverter responseConverter = new HttpServletWebResponseConverter();
    private Json json;

    public DefaultResponseConverter(Json json) {
        this.json = json;
    }

    public HttpServletResponse encode(Object o, InvocationContext<Pair<HttpServletRequest, HttpServletResponse>> context) {
        if (o == null) {
            return this.responseConverter.encode((WebResponse)new SimpleWebResponse(this.json).status(200), context);
        }
        if (o instanceof WebResponse) {
            return this.responseConverter.encode((WebResponse)o, context);
        }
        if (o instanceof String) {
            return this.responseConverter.encode((WebResponse)new SimpleWebResponse(this.json).status(200).body(o.toString()), context);
        }
        return this.responseConverter.encode((WebResponse)new SimpleWebResponse(this.json).status(200).body(this.json.marshal(o)), context);
    }
}

