/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import java.util.logging.Logger;
import net.odoframework.container.util.Json;
import net.odoframework.jetty.runtime.HttpServletWebRequestConverter;
import net.odoframework.jetty.runtime.HttpServletWebResponseConverter;
import net.odoframework.service.Invocation;
import net.odoframework.service.ProviderRuntime;
import net.odoframework.service.RequestConverter;
import net.odoframework.service.Response;
import net.odoframework.service.ResponseConverter;
import net.odoframework.util.Pair;

public class JettyProviderRuntime
implements ProviderRuntime<Pair<HttpServletRequest, HttpServletResponse>, HttpServletRequest, HttpServletResponse> {
    private Logger LOG = Logger.getLogger(JettyProviderRuntime.class.getName());
    private Json json;

    public JettyProviderRuntime(Json json) {
        this.json = json;
    }

    public RequestConverter<?, HttpServletRequest> getProviderDefaultRequestConverter() {
        return new HttpServletWebRequestConverter(this.json);
    }

    public ResponseConverter<? extends Response, HttpServletResponse> getProviderDefaultResponseConverter() {
        return new HttpServletWebResponseConverter();
    }

    public Invocation createInvocation(Pair<HttpServletRequest, HttpServletResponse> containerInstance) {
        return new Invocation(UUID.randomUUID().toString(), containerInstance);
    }
}

