/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.inject.Provider;
import jakarta.servlet.Servlet;
import net.odoframework.container.ModuleBuilder;
import net.odoframework.container.injection.Container;
import net.odoframework.container.util.Json;
import net.odoframework.jetty.runtime.JettyProviderRuntime;
import net.odoframework.jetty.runtime.JettyServer;
import net.odoframework.jetty.runtime.RouterServlet;
import net.odoframework.service.ProviderRuntime;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyModule
extends ModuleBuilder {
    public void build() {
        this.provides(Servlet.class).with(RouterServlet::new);
        this.provides(ThreadPool.class).with(it -> new QueuedThreadPool(it.valueAsInt("odo.jetty.maxthreads", 100), it.valueAsInt("odo.jetty.minthreads", 10), it.valueAsInt("odo.jetty.idletimeout", 120)));
        this.provides(ProviderRuntime.class).with(it -> new JettyProviderRuntime((Json)it.references(Json.class)));
        this.addStartupBean(this.provides(JettyServer.class).with(it -> new JettyServer((Provider<Servlet>)it.lazyReference(Servlet.class), it.valueAsInt("odo.jetty.port", 8080), (ThreadPool)it.references(ThreadPool.class))));
    }

    private void postContainerCreated(Container container) {
    }
}

