/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.odoframework.service.ResponseConverter;
import net.odoframework.service.RuntimeContext;
import net.odoframework.service.web.WebResponse;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

public class HttpServletWebResponseConverter
implements ResponseConverter<WebResponse, HttpServletResponse> {
    public HttpServletResponse apply(WebResponse response) {
        Pair context = (Pair)RuntimeContext.get().orElseThrow(() -> new IllegalStateException("Expected runtime context"));
        HttpServletResponse httpServletResponse = (HttpServletResponse)context.getRight();
        httpServletResponse.setStatus(response.getStatusCode());
        response.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
        response.getContentType().ifPresent(arg_0 -> ((HttpServletResponse)httpServletResponse).setContentType(arg_0));
        if (Strings.isNotBlank((String)response.getBody())) {
            httpServletResponse.setContentLength(response.getBody().length());
            try {
                httpServletResponse.getWriter().write(response.getBody());
                httpServletResponse.getWriter().flush();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return httpServletResponse;
    }
}

