package net.odoframework.jetty.runtime;

import jakarta.inject.Provider;
import jakarta.servlet.Servlet;
import net.odoframework.container.injection.Container;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.ThreadPool;

import java.util.Objects;
import java.util.logging.Logger;

public class JettyServer implements Runnable{


    private static Logger LOG = Logger.getLogger(JettyServer.class.getName());

    private Server server;

    private Provider<Servlet> routerServlet;
    private ThreadPool threadPool;
    private int port;


    public JettyServer(Provider<Servlet> routerServlet, int port, ThreadPool threadPool) {
        this.routerServlet = Objects.requireNonNull(routerServlet);
        if (port < 0) {
            throw new IllegalArgumentException("port and threadPoolSize must be greater than 0");
        }
        this.port = port;
        this.threadPool = Objects.requireNonNull(threadPool);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    server.stop();
                } catch (Exception e) {
                    e.printStackTrace();
                    LOG.severe(e.getMessage());
                }
            }
        }) );
    }

    public void start() {
        server = new Server(threadPool);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        var servletHandler = new ServletHandler();
        servletHandler.addServletWithMapping(new ServletHolder(this.routerServlet.get()), "/*");
        server.setHandler(servletHandler);
        try {
            server.start();
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void main(String[] args) throws Exception{
        Container.getModuleContainer();
    }

    @Override
    public void run() {
        start();
    }
}
