package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.odoframework.container.util.Json;
import net.odoframework.service.*;
import net.odoframework.util.Pair;

import java.util.UUID;
import java.util.logging.Logger;

public class JettyProviderRuntime implements ProviderRuntime<Pair<HttpServletRequest, HttpServletResponse>, HttpServletRequest, HttpServletResponse> {

    private Logger LOG = Logger.getLogger(JettyProviderRuntime.class.getName());

    private Json json;

    public JettyProviderRuntime(Json json) {
        this.json = json;
    }

    @Override
    public RequestConverter<?, HttpServletRequest> getProviderDefaultRequestConverter() {
        return new HttpServletWebRequestConverter(json);
    }

    @Override
    public ResponseConverter<? extends Response, HttpServletResponse> getProviderDefaultResponseConverter() {
        return new HttpServletWebResponseConverter();
    }

    @Override
    public Invocation createInvocation(Pair<HttpServletRequest, HttpServletResponse> containerInstance) {
        return new Invocation(UUID.randomUUID().toString(), containerInstance);
    }

}
