package net.odoframework.jetty.runtime;

import jakarta.servlet.Servlet;
import net.odoframework.container.ModuleBuilder;
import net.odoframework.container.injection.Container;
import net.odoframework.container.util.Json;
import net.odoframework.service.ProviderRuntime;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyModule extends ModuleBuilder {
    @Override
    public void build() {
        provides(Servlet.class).with(RouterServlet::new);

        provides(ThreadPool.class)
                .with(it -> new QueuedThreadPool(
                        it.valueAsInt("odo.jetty.maxthreads", 100),
                        it.valueAsInt("odo.jetty.minthreads", 10),
                        it.valueAsInt("odo.jetty.idletimeout", 120)
                ));

        provides(ProviderRuntime.class).with(it -> new JettyProviderRuntime(it.references(Json.class)));

        addStartupBean(
                provides(JettyServer.class)
                        .with(it -> new JettyServer(
                                it.lazyReference(Servlet.class),
                                it.valueAsInt("odo.jetty.port", 8080),
                                it.references(ThreadPool.class)
                        ))
        );


    }

    private void postContainerCreated(Container container) {

    }
}
