package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.odoframework.service.ResponseConverter;
import net.odoframework.service.RuntimeContext;
import net.odoframework.service.web.WebResponse;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

import java.io.IOException;

public class HttpServletWebResponseConverter implements ResponseConverter<WebResponse, HttpServletResponse> {
    @Override
    public HttpServletResponse apply(WebResponse response) {
        var context = (Pair<HttpServletRequest, HttpServletResponse>) RuntimeContext
                .get()
                .orElseThrow(() -> new IllegalStateException("Expected runtime context"));
        var httpServletResponse = context.getRight();
        httpServletResponse.setStatus(response.getStatusCode());
        response.getHeaders().forEach(httpServletResponse::setHeader);
        response.getContentType().ifPresent(httpServletResponse::setContentType);
        if (Strings.isNotBlank(response.getBody())) {
            httpServletResponse.setContentLength(response.getBody().length());
            try {
                httpServletResponse.getWriter().write(response.getBody());
                httpServletResponse.getWriter().flush();
            } catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return httpServletResponse;
    }
}
