package net.odoframework.jetty.runtime;

import jakarta.servlet.http.HttpServletRequest;
import net.odoframework.container.util.Json;
import net.odoframework.service.RequestConverter;
import net.odoframework.service.web.WebRequest;

public class HttpServletWebRequestConverter implements RequestConverter<WebRequest, HttpServletRequest> {

    private Json json;

    public HttpServletWebRequestConverter(Json json) {
        this.json = json;
    }

    @Override
    public WebRequest apply(HttpServletRequest request) {
        return new HttpServletWebRequest(request, this.json);
    }
}
