/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TrackedMap<K, V>
implements Map<K, V> {
    private Map<K, V> backingMap;
    private Set<K> changedKeys;

    public TrackedMap(Map<K, V> backingMap) {
        this.backingMap = Objects.requireNonNull(backingMap, "backing map is a required parameter");
        this.changedKeys = new LinkedHashSet<K>();
    }

    public TrackedMap() {
        this(new HashMap());
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.changedKeys.add(key);
        return this.backingMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.changedKeys.add(key);
        return this.backingMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.changedKeys.addAll(this.backingMap.keySet());
        this.backingMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    public Map<K, V> getBackingMap() {
        return Collections.unmodifiableMap(this.backingMap);
    }

    public Set<K> getChangedKeys() {
        return Collections.unmodifiableSet(this.changedKeys);
    }
}

