/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.odoframework.util.ListBackedSet;
import net.odoframework.util.WritablePair;

public class ListBackedMap<T, K>
extends AbstractMap<T, K> {
    private final List<WritablePair<T, K>> value;

    public ListBackedMap(int size) {
        this.value = new ArrayList<WritablePair<T, K>>(size);
    }

    public ListBackedMap() {
        this.value = new LinkedList<WritablePair<T, K>>();
    }

    public ListBackedMap(T key, K value) {
        this();
        this.value.add(new WritablePair<T, K>(key, value));
    }

    @Override
    public Set<Map.Entry<T, K>> entrySet() {
        return this.value.stream().map(it -> it).collect(Collectors.toCollection(() -> new ListBackedSet(this.value.size())));
    }

    @Override
    public K put(T key, K value) {
        for (WritablePair<T, K> o : this.value) {
            if (!Objects.equals(o.getKey(), key)) continue;
            K old = o.getValue();
            o.setValue(value);
            return old;
        }
        this.value.add(new WritablePair<T, K>(key, value));
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBackedMap)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListBackedMap that = (ListBackedMap)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

