/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.odoframework.util.Strings;

public class Assertions {
    public static <T> T notNull(T instance, String field) {
        return Objects.requireNonNull(instance, field + " is required");
    }

    public static String notBlank(String instance, String field) {
        return Strings.requireNotBlank(instance, field + " cannot be null or blank");
    }

    public static <Z, T extends Collection<Z>> T notEmpty(T instance, String field) {
        return (T)Optional.ofNullable(instance).filter(it -> !it.isEmpty()).orElseThrow(() -> new IllegalArgumentException(field + " cannot be null or empty"));
    }

    public static <T> T[] notEmptyArray(T[] instance, String field) {
        return Optional.ofNullable(instance).filter(it -> ((Object[])it).length > 0).orElseThrow(() -> new IllegalArgumentException(field + " cannot be null or empty"));
    }

    public static IllegalArgumentException notExisting(String field) {
        return new IllegalArgumentException(field + " does not exist");
    }

    public static <T extends Number> T assertPositive(T number, String field) {
        if (number.doubleValue() < 1.0) {
            throw new IllegalArgumentException(field + " must be greater than 1");
        }
        return number;
    }
}

