/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.odoframework.sql.BaseUpdateStatement;
import net.odoframework.util.Strings;

public class Update
extends BaseUpdateStatement {
    private Map<String, Supplier<?>> whereClause;

    public Update(String table) {
        super(table);
    }

    public static Update update(String table) {
        return new Update(table);
    }

    public Update value(String name, Object value) {
        return this.value(name, () -> value);
    }

    public Update value(String name, Supplier<?> value) {
        this.addField(name, value);
        return this;
    }

    @Override
    public String getSql() {
        String sql = "update " + this.getTable() + " set";
        sql = sql + this.getFields().keySet().stream().map(it -> "\n\t" + it + " = ?").collect(Collectors.joining(","));
        if (this.whereClause != null && !this.whereClause.isEmpty()) {
            sql = sql + "\nwhere";
            sql = sql + this.whereClause.keySet().stream().map(it -> "\n\t" + it + " = ?").collect(Collectors.joining(" and "));
        }
        return sql;
    }

    public Update where(String name, Object value) {
        return this.where(name, () -> value);
    }

    public Update where(String name, Supplier<?> value) {
        if (this.whereClause == null) {
            this.whereClause = new LinkedHashMap();
        }
        this.whereClause.put(Strings.requireNotBlank(name, "name is required"), Objects.requireNonNull(value, "value is required"));
        return this;
    }

    @Override
    public Map<Integer, Object> getBindings() {
        AtomicInteger cnt = new AtomicInteger(1);
        LinkedHashMap<Integer, Object> map = new LinkedHashMap<Integer, Object>();
        this.getFields().values().forEach(it -> map.put(cnt.getAndIncrement(), it.get()));
        if (this.whereClause != null) {
            this.whereClause.values().forEach(it -> map.put(cnt.getAndIncrement(), it.get()));
        }
        return map;
    }
}

