/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.odoframework.sql.DBStatement;
import net.odoframework.util.Strings;

public class ObjectUpdate<T>
implements DBStatement {
    private String tableName;
    private T instance;
    private Map<String, Function<T, ?>> mappers;
    private Map<String, Function<T, ?>> whereClause;

    public ObjectUpdate(String tableName, T instance) {
        this.tableName = Strings.requireNotBlank(tableName, "tableName is required");
        this.instance = Objects.requireNonNull(instance, "instance cannot be null");
    }

    public static <T> ObjectUpdate<T> update(String tableName, T instance) {
        return new ObjectUpdate<T>(tableName, instance);
    }

    public ObjectUpdate<T> addField(String name, Function<T, ?> mapper) {
        if (this.mappers == null) {
            this.mappers = new LinkedHashMap();
        }
        this.mappers.put(Strings.requireNotBlank(name, "name is required"), Objects.requireNonNull(mapper, "mapper is required"));
        return this;
    }

    public ObjectUpdate<T> where(String name, Function<T, ?> mapper) {
        if (this.whereClause == null) {
            this.whereClause = new LinkedHashMap();
        }
        this.whereClause.put(Strings.requireNotBlank(name, "name is required"), Objects.requireNonNull(mapper, "mapper is required"));
        return this;
    }

    @Override
    public String getSql() {
        if (this.mappers == null || this.mappers.isEmpty()) {
            throw new IllegalStateException("must pass at least one field to update");
        }
        String sql = "update " + this.tableName + " set";
        sql = sql + this.mappers.keySet().stream().map(it -> "\n\t" + it + " = ?").collect(Collectors.joining(","));
        if (this.whereClause != null && !this.whereClause.isEmpty()) {
            sql = sql + "\nwhere";
            sql = sql + this.whereClause.keySet().stream().map(it -> "\n\t" + it + " = ?").collect(Collectors.joining(" and "));
        }
        return sql;
    }

    @Override
    public Map<Integer, Object> getBindings() {
        AtomicInteger cnt = new AtomicInteger(1);
        LinkedHashMap<Integer, Object> map = new LinkedHashMap<Integer, Object>();
        this.mappers.values().forEach(it -> map.put(cnt.getAndIncrement(), it.apply(this.instance)));
        if (this.whereClause != null) {
            this.whereClause.values().forEach(it -> map.put(cnt.getAndIncrement(), it.apply(this.instance)));
        }
        return map;
    }
}

