/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.odoframework.sql.DBStatement;
import net.odoframework.util.Strings;

public class ObjectInsert<T>
implements DBStatement {
    private String sqlCache = "";
    private final String tableName;
    private final T instance;
    private Map<String, Function<T, ?>> mappers;

    public ObjectInsert(String tableName, T instance) {
        this.tableName = Strings.requireNotBlank(tableName, "tableName is required");
        this.instance = Objects.requireNonNull(instance, "instance cannot be null");
    }

    public static <T> ObjectInsert<T> insert(String tableName, T instance) {
        return new ObjectInsert<T>(tableName, instance);
    }

    public ObjectInsert<T> addField(String name, Function<T, ?> mapper) {
        if (this.mappers == null) {
            this.mappers = new LinkedHashMap();
        }
        this.mappers.put(Strings.requireNotBlank(name, "name is required"), Objects.requireNonNull(mapper, "mapper is required"));
        return this;
    }

    @Override
    public String getSql() {
        if (this.mappers == null || this.mappers.isEmpty()) {
            throw new IllegalStateException("must pass at least one field to update");
        }
        String sql = "insert into " + this.tableName + "\n\t(";
        sql = sql + String.join((CharSequence)", ", this.mappers.keySet());
        sql = sql + ")\nvalues\n\t(";
        sql = sql + this.mappers.keySet().stream().map(it -> "? ").collect(Collectors.joining(", "));
        sql = sql + ")";
        return sql;
    }

    @Override
    public Map<Integer, Object> getBindings() {
        AtomicInteger cnt = new AtomicInteger(1);
        LinkedHashMap<Integer, Object> map = new LinkedHashMap<Integer, Object>();
        this.mappers.values().forEach(it -> map.put(cnt.getAndIncrement(), it.apply(this.instance)));
        return map;
    }
}

