/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import net.odoframework.sql.DBStatement;
import net.odoframework.sql.Query;
import net.odoframework.sql.ResultSetSpliterator;
import net.odoframework.sql.SQLConsumer;
import net.odoframework.sql.SQLFunction;
import net.odoframework.sql.SQLTemplate;
import net.odoframework.sql.SQLWrappedException;

public class DefaultSQLTemplate
implements SQLTemplate {
    private final DataSource dataSource;

    public DefaultSQLTemplate(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource cannot be null");
    }

    @Override
    public void execute(DBStatement sql, SQLConsumer<ResultSet> rsConsumer) {
        try (Query query = new Query(sql, this.dataSource, false);){
            rsConsumer.accept(query.getResultSet());
        }
        catch (SQLException throwables) {
            throw new IllegalStateException(throwables);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T execute(DBStatement sql, SQLFunction<ResultSet, T> mapper) {
        try (Query query = new Query(sql, this.dataSource, false);){
            ResultSet t = mapper.apply(query.getResultSet());
            return (T)t;
        }
        catch (SQLException throwables) {
            throw new IllegalStateException(throwables);
        }
    }

    private void createStatement(DBStatement sql, PreparedStatement statement) throws SQLException {
        Map<Integer, Object> bindings = sql.getBindings();
        if (!bindings.isEmpty()) {
            for (Map.Entry<Integer, Object> entry : bindings.entrySet()) {
                statement.setObject(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DBStatement sql) {
        try (Connection conn = this.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = conn.prepareStatement(sql.getSql());
                try {
                    this.createStatement(sql, statement);
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException throwables) {
            throw new SQLWrappedException(throwables);
        }
    }

    @Override
    public <T> Stream<T> stream(DBStatement sql, SQLFunction<ResultSet, T> row) {
        return StreamSupport.stream(new ResultSetSpliterator(new Query(sql, this.dataSource, true)), false).map(it -> {
            try {
                return row.apply((ResultSet)it);
            }
            catch (SQLException throwables) {
                throw new SQLWrappedException(throwables);
            }
        });
    }

    @Override
    public <T> T doInTransaction(Supplier<T> supplier) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            T result = supplier.get();
            conn.commit();
            T t = result;
            return t;
        }
        catch (Exception throwables) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    throw new SQLWrappedException(e);
                }
            }
            if (throwables instanceof SQLException) {
                throw new SQLWrappedException((SQLException)throwables);
            }
            throw new IllegalStateException(throwables);
        }
        finally {
            this.safeClose(conn);
        }
    }

    private void safeClose(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

