/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.ResultSet;
import net.odoframework.sql.SQLUtils;
import net.odoframework.util.Strings;

public abstract class ColumnReference {
    public abstract <T> T read(ResultSet var1);

    public abstract <T> void write(ResultSet var1, T var2);

    public static ColumnReference index(int index) {
        return new IndexReference(index);
    }

    public static ColumnReference name(String name) {
        return new NameReference(name);
    }

    private static class IndexReference
    extends ColumnReference {
        private int index;

        public IndexReference(int index) {
            if (index < 1) {
                throw new IllegalArgumentException("index must be > 0");
            }
            this.index = index;
        }

        @Override
        public <T> T read(ResultSet rs) {
            return SQLUtils.getColumn(rs, this.index);
        }

        @Override
        public <T> void write(ResultSet rs, T value) {
            SQLUtils.setColumn(rs, this.index, value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexReference)) {
                return false;
            }
            IndexReference other = (IndexReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.index == other.index;
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndexReference;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.index;
            return result;
        }
    }

    private static class NameReference
    extends ColumnReference {
        private String columnName;

        public NameReference(String columnName) {
            this.columnName = Strings.requireNotBlank(columnName, "columnName cannot be null");
        }

        @Override
        public <T> T read(ResultSet rs) {
            return SQLUtils.getColumn(rs, this.columnName);
        }

        @Override
        public <T> void write(ResultSet rs, T value) {
            SQLUtils.setColumn(rs, this.columnName, value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameReference)) {
                return false;
            }
            NameReference other = (NameReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.columnName;
            String other$columnName = other.columnName;
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NameReference;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.columnName;
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }
    }
}

