/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.http;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import net.odoframework.http.Http;
import net.odoframework.http.HttpError;
import net.odoframework.http.HttpRequest;
import net.odoframework.http.HttpResponse;
import net.odoframework.util.Either;
import net.odoframework.util.IO;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

public class URLConnectionHttpService
implements Http {
    @Override
    public Either<HttpResponse, HttpError> execute(HttpRequest request) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)request.getUrl().openConnection();
            connection.setRequestMethod(request.getMethod());
            connection.setDoInput(true);
            connection.setConnectTimeout(request.getTimeout());
            connection.setReadTimeout(request.getTimeout());
            for (Map.Entry<String, List<String>> header : request.getHeaders().entrySet()) {
                connection.setRequestProperty(header.getKey(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)header.getValue()));
                if (request.getCredentials() == null) continue;
                for (Pair<String, String> authHeader : request.getCredentials().toHeader()) {
                    connection.setRequestProperty(authHeader.getLeft(), authHeader.getRight());
                }
            }
            if (!Strings.isOneOf(request.getMethod(), "GET", "HEAD")) {
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(0);
                IO.pipe(request.getBody(), connection.getOutputStream());
            }
            PushbackInputStream bis = new PushbackInputStream(connection.getInputStream());
            byte[] buffer = bis.readAllBytes();
            Either either = Either.left(new HttpResponse(connection.getResponseCode(), new ByteArrayInputStream(buffer)));
            return either;
        }
        catch (FileNotFoundException e) {
            String result = IO.streamToString(connection.getErrorStream());
            try {
                Either<HttpResponse, HttpError> either = Either.right(new HttpError(404, connection.getResponseMessage(), new ByteArrayInputStream(result.getBytes(request.getCharSet()))));
                return either;
            }
            catch (IOException ioException) {
                throw new IllegalStateException(e);
            }
        }
        catch (IOException e) {
            try {
                Either<HttpResponse, HttpError> result = Either.right(new HttpError(connection.getResponseCode(), e.getMessage(), new ByteArrayInputStream(e.getMessage().getBytes(request.getCharSet()))));
                return result;
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Unable to get response status");
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

