/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

public class URIBuilder {
    private static final Map<String, DateTimeFormatter> FORMATS = new HashMap<String, DateTimeFormatter>();
    private String protocol = "http";
    private String user = null;
    private String password = null;
    private String server;
    private int port = -1;
    private Set<Pair<String, String>> queryParameters;
    private String path;

    public static URIBuilder uri(String server) {
        return new URIBuilder().server(server);
    }

    public static URIBuilder uri(String protocol, String server) {
        return new URIBuilder().protocol(protocol).server(server);
    }

    private Set<Pair<String, String>> queryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new LinkedHashSet<Pair<String, String>>();
        }
        return this.queryParameters;
    }

    public URIBuilder queryParam(String param, Object value) {
        this.queryParameters().add(Pair.cons(Strings.requireNotBlank(param, "parameters is a required parameter"), Objects.requireNonNull(value).toString()));
        return this;
    }

    public URIBuilder server(String server) {
        this.server = Strings.requireNotBlank(server, "server is a required parameter");
        return this;
    }

    public URIBuilder path(String path) {
        this.path = path;
        return this;
    }

    public URIBuilder protocol(String protocol) {
        this.protocol = Strings.requireNotBlank(protocol, "protocol is a required parameter");
        return this;
    }

    public URIBuilder user(String user) {
        this.user = Strings.requireNotBlank(user, "user is a required parameter");
        return this;
    }

    public URIBuilder password(String password) {
        this.password = Strings.requireNotBlank(password, "user is a required parameter");
        return this;
    }

    public URIBuilder port(int port) {
        if (port < 1) {
            throw new IllegalArgumentException("port must be a positive number");
        }
        this.port = port;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URIBuilder queryParam(String param, Temporal value, String format) {
        DateTimeFormatter formatter = null;
        if (!FORMATS.containsKey(Strings.requireNotBlank(format, "format is a required parameter"))) {
            Map<String, DateTimeFormatter> map = FORMATS;
            synchronized (map) {
                formatter = FORMATS.put(format, DateTimeFormatter.ofPattern(format));
            }
        } else {
            formatter = FORMATS.get(format);
        }
        return this.queryParam(param, formatter.format(value));
    }

    public Set<Pair<String, String>> getQueryParameters() {
        return this.queryParameters();
    }

    public String toString() {
        String credentials = Stream.of(this.user, this.password).filter(Strings::isNotBlank).collect(Collectors.joining(":"));
        String serverAddress = this.port > 0 ? String.join((CharSequence)":", this.server, Integer.toString(this.port)) : this.server;
        String urn = Strings.isNotBlank(this.path) ? String.join((CharSequence)"/", serverAddress, this.path) : serverAddress;
        String authority = Stream.of(credentials, urn).filter(Strings::isNotBlank).collect(Collectors.joining("@"));
        String queryString = this.queryParameters().stream().map(it -> (String)it.getLeft() + "=" + (String)it.getRight()).collect(Collectors.joining("&"));
        String url = this.protocol.trim() + "://" + authority;
        return Stream.of(url, queryString).filter(Strings::isNotBlank).collect(Collectors.joining("?"));
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public URL toURL() {
        try {
            return this.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

