/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.http;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.odoframework.util.IO;

public class BaseHttpResponse {
    protected int code;
    protected InputStream body;

    public BaseHttpResponse(int code, InputStream body) {
        this.code = code;
        this.body = body;
    }

    public int getCode() {
        return this.code;
    }

    public Optional<InputStream> body() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> bodyAsString() {
        return this.body().map(IO::streamToString);
    }

    public <T> Optional<T> bodyAs(Function<String, T> converter) {
        return this.bodyAsString().map(converter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseHttpResponse that = (BaseHttpResponse)o;
        return this.code == that.code && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.body);
    }
}

