/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import net.odoframework.util.Strings;

public class StringToNumberConverter<T extends Number>
implements Function<String, T> {
    private Function<Number, T> lastMileConverter;

    public StringToNumberConverter(Function<Number, T> lastMileConverter) {
        this.lastMileConverter = Objects.requireNonNull(lastMileConverter);
    }

    @Override
    public T apply(String s) {
        if (Strings.isBlank(s)) {
            return null;
        }
        Number number = s.trim().indexOf(46) > -1 ? new BigDecimal(s) : new BigInteger(s);
        return (T)((Number)this.lastMileConverter.apply(number));
    }
}

