/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.odoframework.beans.types.Converters;
import net.odoframework.beans.types.NumberCoercingConverter;
import net.odoframework.beans.types.StringToResourceConverter;
import net.odoframework.util.Pair;
import net.odoframework.util.Resource;

public class ConverterRegistry {
    private static Map<Pair<Class<?>, Class<?>>, Function<?, ?>> CONVERTERS = new HashMap();

    public static <T, K> Optional<Function<T, K>> get(Class<T> a, Class<K> b) {
        if (a.getName().equals(b.getName())) {
            return Optional.of(it -> it);
        }
        return Optional.ofNullable(CONVERTERS.get(Pair.cons(a, b)));
    }

    public static <T, K> void add(Class<T> from, Class<K> to, Function<T, K> converter) {
        CONVERTERS.put(new Pair<Class<T>, Class<K>>(Objects.requireNonNull(from), Objects.requireNonNull(to)), Objects.requireNonNull(converter));
    }

    static {
        ConverterRegistry.add(Integer.class, String.class, Converters.INT_TO_STRING);
        ConverterRegistry.add(String.class, Integer.class, Converters.STRING_TO_INT);
        ConverterRegistry.add(Double.class, String.class, Converters.DOUBLE_TO_STRING);
        ConverterRegistry.add(String.class, Double.class, Converters.STRING_TO_DOUBLE);
        ConverterRegistry.add(Long.class, String.class, Converters.LONG_TO_STRING);
        ConverterRegistry.add(String.class, Long.class, Converters.STRING_TO_LONG);
        ConverterRegistry.add(Float.class, String.class, Converters.FLOAT_TO_STRING);
        ConverterRegistry.add(String.class, Float.class, Converters.STRING_TO_FLOAT);
        ConverterRegistry.add(Byte.class, String.class, Converters.BYTE_TO_STRING);
        ConverterRegistry.add(String.class, Byte.class, Converters.STRING_TO_BYTE);
        ConverterRegistry.add(Short.class, String.class, Converters.SHORT_TO_STRING);
        ConverterRegistry.add(String.class, Short.class, Converters.STRING_TO_SHORT);
        ConverterRegistry.add(String.class, BigInteger.class, Converters.STRING_TO_BIGINTEGER);
        ConverterRegistry.add(BigInteger.class, String.class, Converters.BIGINTEGER_TO_STRING);
        ConverterRegistry.add(String.class, BigDecimal.class, Converters.STRING_TO_BIGDECIMAL);
        ConverterRegistry.add(BigDecimal.class, String.class, Converters.BIGDECIMAL_TO_STRING);
        ConverterRegistry.add(Boolean.class, String.class, Converters.BOOLEAN_TO_STRING);
        ConverterRegistry.add(String.class, Boolean.class, Converters.STRING_TO_BOOLEAN);
        ConverterRegistry.add(LocalDate.class, String.class, Converters.ISO_DATE_TO_STRING);
        ConverterRegistry.add(String.class, LocalDate.class, Converters.STRING_TO_ISO_DATE);
        ConverterRegistry.add(LocalDateTime.class, String.class, Converters.ISO_DATETIME_TO_STRING);
        ConverterRegistry.add(String.class, LocalDateTime.class, Converters.STRING_TO_ISO_DATETIME);
        CONVERTERS.putAll(NumberCoercingConverter.numberCoercions());
        CONVERTERS.put(new Pair<Class<String>, Class<Resource>>(String.class, Resource.class), new StringToResourceConverter());
    }
}

