/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans;

import java.util.Objects;
import java.util.function.Function;
import net.odoframework.beans.Binding;

public class OneWayBinding<Source, SourceType, Target, TargetType> {
    protected Function<TargetType, SourceType> fromTarget;
    protected Binding<Source, SourceType> sourceBinding;
    protected Binding<Target, TargetType> targetBinding;

    public OneWayBinding(Binding<Source, SourceType> sourceBinding, Binding<Target, TargetType> targetBinding, Function<TargetType, SourceType> fromTarget) {
        this.fromTarget = Objects.requireNonNull(fromTarget, "fromTarget is a required parameter");
        this.sourceBinding = Objects.requireNonNull(sourceBinding, "sourceBinding is a required parameter");
        this.targetBinding = Objects.requireNonNull(targetBinding, "targetBinding is a required parameter");
    }

    public SourceType getSource(Source source) {
        return this.sourceBinding.get(source);
    }

    public TargetType getTarget(Target target) {
        return this.targetBinding.get(target);
    }

    public SourceType bindFrom(Target target, Source source) {
        TargetType targetValue = this.targetBinding.get(target);
        SourceType sourceValue = this.fromTarget.apply(targetValue);
        this.sourceBinding.set(source, sourceValue);
        return sourceValue;
    }
}

