/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.odoframework.beans.ConvertingPropertyBinding;
import net.odoframework.beans.MapToObjectRegistry;
import net.odoframework.util.ListBackedMap;
import net.odoframework.util.Strings;

public class ObjectToMap<Source> {
    private final Map<String, Object> targetMap = new ListBackedMap<String, Object>();
    private Map<String, ConvertingPropertyBinding> bindings;
    private final boolean strict;
    private MapToObjectRegistry registry;
    private Supplier<Source> newInstanceConstructor;

    public ObjectToMap(boolean strict, MapToObjectRegistry registry, Supplier<Source> newInstanceConstructor) {
        this.strict = strict;
        this.registry = registry;
        this.newInstanceConstructor(newInstanceConstructor);
    }

    public ObjectToMap(boolean strict, Supplier<Source> newInstanceConstructor) {
        this(strict, null, newInstanceConstructor);
    }

    public ObjectToMap(Supplier<Source> newInstanceConstructor) {
        this(true, null, newInstanceConstructor);
    }

    public ObjectToMap<Source> binding(String name, ConvertingPropertyBinding<Source, ?, ?> binding) {
        if (this.bindings == null) {
            this.bindings = new LinkedHashMap<String, ConvertingPropertyBinding>();
        }
        this.bindings.put(Strings.requireNotBlank(name, "name is a required parameter"), Objects.requireNonNull(binding, "binding is a required parameter"));
        return this;
    }

    public ObjectToMap newInstanceConstructor(Supplier<Source> source) {
        this.newInstanceConstructor = Objects.requireNonNull(source, "source is a required constructor");
        return this;
    }

    public Supplier<Source> getNewInstanceConstructor() {
        return this.newInstanceConstructor;
    }

    public Source fromTarget(Map<String, ?> instance) {
        Objects.requireNonNull(instance);
        if (this.bindings == null || this.bindings.isEmpty()) {
            throw new IllegalStateException("no bindings have been defined");
        }
        Source newInstance = this.getNewInstanceConstructor().get();
        this.bindings.forEach((name, binding) -> {
            if (instance.containsKey(name)) {
                Object sourceValue = this.targetMap.get(name);
                if (sourceValue instanceof Map && this.registry != null && this.registry.contains(sourceValue.getClass())) {
                    this.registry.get(sourceValue.getClass()).map(it -> it.fromTarget((Map)sourceValue));
                } else {
                    binding.setConverted(instance, sourceValue);
                }
            } else if (this.strict) {
                throw new IllegalStateException("targetMap has no key" + name);
            }
        });
        return newInstance;
    }

    public Map<String, ?> toTarget(Source instance) {
        Objects.requireNonNull(instance);
        if (this.bindings == null || this.bindings.isEmpty()) {
            throw new IllegalStateException("no bindings have been defined");
        }
        this.bindings.forEach((name, binding) -> {
            Object value = binding.getConverted(instance);
            this.targetMap.put((String)name, value);
        });
        return this.targetMap;
    }

    public boolean isStrict() {
        return this.strict;
    }
}

