/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.beans.PropertyBinding;
import net.odoframework.beans.types.ConverterRegistry;

public class ConvertingPropertyBinding<Source, TargetType, SourceType>
extends PropertyBinding<Source, TargetType> {
    private Function<SourceType, TargetType> toTarget = src -> src;
    private Function<TargetType, SourceType> fromTarget = src -> src;

    public ConvertingPropertyBinding(Function<Source, TargetType> getter, BiConsumer<Source, TargetType> setter, Function<SourceType, TargetType> toTarget, Function<TargetType, SourceType> fromTarget) {
        super(getter, setter);
        this.toTarget = toTarget;
        this.fromTarget = fromTarget;
    }

    public ConvertingPropertyBinding(Function<Source, TargetType> getter) {
        super(getter);
    }

    public ConvertingPropertyBinding(BiConsumer<Source, TargetType> setter) {
        super(setter);
    }

    public SourceType getConverted(Source instance) {
        Object targetType = super.get(instance);
        return Objects.requireNonNull(this.fromTarget, "fromTarget is required").apply(targetType);
    }

    public void setConverted(Source instance, SourceType value) {
        TargetType convertedValue = Objects.requireNonNull(this.toTarget, "toTarget is required").apply(value);
        super.set(instance, convertedValue);
    }

    public static <T, K> ConvertingPropertyBinding<T, K, K> passThrough(Function<T, K> getter, BiConsumer<T, K> setter) {
        return new ConvertingPropertyBinding<T, Object, Object>(getter, setter, it -> it, it -> it);
    }

    public static <T, K, Z> ConvertingPropertyBinding<T, K, Z> withConversion(Function<T, K> getter, BiConsumer<T, K> setter, Class<K> target, Class<Z> raw) {
        Function<K, Z> targetConverter = ConverterRegistry.get(target, raw).orElseThrow();
        Function<Z, K> rawConverter = ConverterRegistry.get(raw, target).orElseThrow();
        return new ConvertingPropertyBinding<T, K, Z>(getter, setter, rawConverter, targetConverter);
    }
}

