package net.odoframework.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ClasspathResource implements Resource{

    private String path;

    public ClasspathResource(String path) {
        this.path = Strings.requireNotBlank(path, "path is a required parameter");
    }

    @Override
    public InputStream getStream() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }


}
