package net.odoframework.beans;

import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MapToObjectMapper<T> {

    private final Map<String, Binding<T, ?>> bindings;

    @SafeVarargs
    public MapToObjectMapper(Pair<String, Binding<T, ?>>... properties) {
        bindings = new LinkedHashMap<>();
        for (Pair<String, Binding<T, ?>> property : properties) {
            add(property.getLeft(), property.getRight());
        }
    }

    public MapToObjectMapper<T> add(String key, Binding<T, ?> binding) {
        bindings.put(Strings.requireNotBlank(key), Objects.requireNonNull(binding));
        return this;
    }
}
