package net.odoframework.beans;

import net.odoframework.util.ListBackedSet;

import java.util.Set;
import java.util.function.Function;

import static java.util.Objects.requireNonNull;

public class CompositeOneWayBinding<T, K, Z, J> extends OneWayBinding<T, K, Z, J> {

    private Set<OneWayBinding<Object, Object, Object, Object>> bindings;

    public CompositeOneWayBinding(Binding<T, K> sourceBinding, Binding<Z, J> targetBinding, Function<J, K> fromTarget) {
        super(sourceBinding, targetBinding, fromTarget);
        this.bindings = new ListBackedSet<>(5);
    }

    public CompositeOneWayBinding<T,K,Z,J> binding(OneWayBinding<Object, Object, Object, Object> binding) {
        this.bindings.add(requireNonNull(binding, "binding is required"));


        return this;
    }


    @Override
    public K bindFrom(Z z, T t) {
        final var source = super.getSource(t);
        final var target = super.getTarget(z);
        if (source != null) {
            return source;
        }
        bindings.forEach(binding -> {
            binding.bindFrom(source, target);
        });
        return source;
    }
}
