/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Pair<T, K> {
    T left;
    K right;

    public Pair(T left, K right) {
        this.left = Objects.requireNonNull(left);
        this.right = right;
    }

    public static <A, B> Pair<A, B> cons(A left, B right) {
        return new Pair<A, B>(left, right);
    }

    @SafeVarargs
    public static <T, K> Map<T, K> toMap(Pair<T, K> ... pairs) {
        LinkedHashMap<T, K> map = new LinkedHashMap<T, K>();
        for (Pair<T, K> tkEntry : pairs) {
            map.put(tkEntry.getLeft(), tkEntry.getRight());
        }
        return map;
    }

    public T getLeft() {
        return this.left;
    }

    public K getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return this.left.equals(pair.left) && Objects.equals(this.right, pair.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

