/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.odoframework.util.Strings;

public class ConfigLoader {
    public static final String CONFIG_OR = "\\|";

    public static Properties loadProperties(String ... files) {
        return ConfigLoader.loadProperties(ConfigLoader.class, files);
    }

    public static Properties loadProperties(Class<?> source, String ... files) {
        Properties properties = new Properties();
        for (String file : files) {
            ConfigLoader.load(source, file).ifPresent(properties::putAll);
        }
        System.getenv().forEach((key, value) -> properties.put("env." + key, value));
        properties.putAll((Map<?, ?>)System.getProperties());
        return ConfigLoader.interpolate(properties);
    }

    private static Properties interpolate(Properties p) {
        Properties newProperties = new Properties();
        p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String theValue;
            String string = theValue = value != null ? value.toString().trim() : "";
            if (theValue.startsWith("${") && theValue.endsWith("}")) {
                String[] parts;
                theValue = theValue.substring(2);
                theValue = (theValue = theValue.substring(0, theValue.length() - 1)).contains("|") ? ((parts = theValue.split(CONFIG_OR)).length > 1 && !p.containsKey(parts[0].trim()) ? p.getProperty(parts[1].trim(), parts[1].trim()) : p.getProperty(parts[0], "").trim()) : p.getProperty(theValue, "");
            }
            newProperties.setProperty(key.toString(), theValue);
        }));
        return newProperties;
    }

    private static Optional<Properties> load(Class<?> sourceClass, String name) {
        if (sourceClass.getModule() == null) {
            return ConfigLoader.loadFile(sourceClass, name);
        }
        return ConfigLoader.resolve(name, sourceClass.getModule());
    }

    private static Optional<Properties> loadFile(Class<?> sourceClass, String file) {
        try {
            Properties properties = new Properties();
            InputStream resourceAsStream = sourceClass.getResourceAsStream(file);
            if (resourceAsStream == null) {
                return Optional.empty();
            }
            properties.load(resourceAsStream);
            return Optional.of(properties);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(file + " could not be loaded");
        }
    }

    public static Optional<Properties> resolve(String name, Module sourceModule) {
        try {
            InputStream resource = sourceModule.getResourceAsStream(name);
            if (resource != null) {
                Properties props = new Properties();
                props.load(resource);
                return Optional.of(props);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to load " + name + ": " + e.getMessage());
        }
        Properties properties = new Properties();
        ModuleLayer.boot().modules().stream().filter(ConfigLoader::filterModule).map(it -> {
            try {
                return it.getResourceAsStream(name);
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load " + name + ": " + e.getMessage());
            }
        }).filter(Objects::nonNull).map(it -> {
            Properties props = new Properties();
            try {
                props.load((InputStream)it);
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load " + name + ": " + e.getMessage());
            }
            return props;
        }).forEach(properties::putAll);
        return Optional.of(properties);
    }

    private static boolean filterModule(Module it) {
        return !it.getName().startsWith("java") && !it.getName().startsWith("javax") && !it.getName().startsWith("jdk") && !it.getName().startsWith("jakarta") && !it.getName().startsWith("kotlin") && !it.getName().startsWith("org.graalvm") && !it.getName().startsWith("lombok") && !it.getName().startsWith("com.google") && !it.getName().startsWith("org.slf4j") && !it.getName().startsWith("org.eclipse") && !it.getName().startsWith("org.apache");
    }

    public static Properties findByPrefix(Properties p, String prefix, boolean stripPrefix) {
        Properties result = new Properties();
        result.putAll(Objects.requireNonNull(p, "properties is a required parameter").entrySet().stream().filter(it -> it.getKey().toString().startsWith(prefix)).filter(it -> it.getValue() != null).collect(Collectors.toMap(entry -> {
            if (stripPrefix) {
                return ConfigLoader.stripPrefix(entry.getKey().toString(), prefix);
            }
            return entry.getKey();
        }, Map.Entry::getValue)));
        return result;
    }

    public static String stripPrefix(String str, String prefix) {
        if (Strings.isBlank(str) || Strings.isBlank(prefix)) {
            return prefix;
        }
        if (!str.startsWith(prefix)) {
            throw new IllegalArgumentException(str + " does not start with the the prefix: " + prefix);
        }
        String remainder = str.substring(prefix.length());
        if (remainder.startsWith(".") && remainder.length() > 1) {
            return remainder.substring(1).trim();
        }
        if (remainder.startsWith(".")) {
            return "";
        }
        return remainder.trim();
    }
}

