/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.ResultSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.sql.ColumnReference;

public class WriteProperty<T, K, Z> {
    private ColumnReference ref;
    private BiConsumer<T, K> setter;
    private Function<Z, K> converter;

    public WriteProperty(ColumnReference ref, BiConsumer<T, K> setter, Function<Z, K> converter) {
        this.ref = Objects.requireNonNull(ref, "columnReference cannot be null");
        this.setter = Objects.requireNonNull(setter, "setter is required");
        this.converter = converter != null ? converter : it -> it;
    }

    public void read(ResultSet rs, T instance) {
        Object unconverted = this.ref.read(rs);
        Object converted = unconverted != null ? (Object)this.converter.apply(unconverted) : null;
        this.setter.accept(instance, converted);
    }
}

