/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import net.odoframework.sql.SQLWrappedException;
import net.odoframework.util.NullSafe;

public class ResultSetWrapper {
    private final ResultSet resultSet;

    public ResultSetWrapper(ResultSet resultSet) {
        this.resultSet = Objects.requireNonNull(resultSet, "resultSet is required");
    }

    public <T> T get(int col) {
        return (T)SQLWrappedException.map(col, this.resultSet::getObject);
    }

    public <T> T get(String col) {
        return (T)SQLWrappedException.map(col, this.resultSet::getObject);
    }

    public int getInt(int col) {
        return SQLWrappedException.map(col, this.resultSet::getInt);
    }

    public int getInt(String col) {
        return SQLWrappedException.map(col, this.resultSet::getInt);
    }

    public Long getLong(int col) {
        return SQLWrappedException.map(col, this.resultSet::getLong);
    }

    public Float getFloat(int col) {
        return SQLWrappedException.map(col, this.resultSet::getFloat);
    }

    public Float getFloat(String col) {
        return SQLWrappedException.map(col, this.resultSet::getFloat);
    }

    public Double getDouble(int col) {
        return SQLWrappedException.map(col, this.resultSet::getDouble);
    }

    public Double getDouble(String col) {
        return SQLWrappedException.map(col, this.resultSet::getDouble);
    }

    public Long getLong(String col) {
        return SQLWrappedException.map(col, this.resultSet::getLong);
    }

    public Short getShort(int col) {
        return SQLWrappedException.map(col, this.resultSet::getShort);
    }

    public Short getShort(String col) {
        return SQLWrappedException.map(col, this.resultSet::getShort);
    }

    public Byte getByte(String col) {
        return SQLWrappedException.map(col, this.resultSet::getByte);
    }

    public Byte getByte(int col) {
        return SQLWrappedException.map(col, this.resultSet::getByte);
    }

    public Boolean getBoolean(String col) {
        return SQLWrappedException.map(col, this.resultSet::getBoolean);
    }

    public byte[] getBytes(int col) {
        return SQLWrappedException.map(col, this.resultSet::getBytes);
    }

    public byte[] getBytes(String col) {
        return SQLWrappedException.map(col, this.resultSet::getBytes);
    }

    public String getString(int col) {
        return SQLWrappedException.map(col, this.resultSet::getString);
    }

    public String getString(String col) {
        return SQLWrappedException.map(col, this.resultSet::getString);
    }

    public Array getArray(String col) {
        return SQLWrappedException.map(col, this.resultSet::getArray);
    }

    public Array getArray(int col) {
        return SQLWrappedException.map(col, this.resultSet::getArray);
    }

    public String getNString(int col) {
        return SQLWrappedException.map(col, this.resultSet::getNString);
    }

    public String getNString(String col) {
        return SQLWrappedException.map(col, this.resultSet::getNString);
    }

    public Clob getClob(String col) {
        return SQLWrappedException.map(col, this.resultSet::getClob);
    }

    public Clob getClob(int col) {
        return SQLWrappedException.map(col, this.resultSet::getClob);
    }

    public Blob getBlob(int col) {
        return SQLWrappedException.map(col, this.resultSet::getBlob);
    }

    public Blob getBlob(String col) {
        return SQLWrappedException.map(col, this.resultSet::getBlob);
    }

    public InputStream getAsciiStream(String col) {
        return SQLWrappedException.map(col, this.resultSet::getAsciiStream);
    }

    public InputStream getAsciiStream(int col) {
        return SQLWrappedException.map(col, this.resultSet::getAsciiStream);
    }

    public InputStream getBinaryStream(int col) {
        return SQLWrappedException.map(col, this.resultSet::getBinaryStream);
    }

    public InputStream getBinaryStream(String col) {
        return SQLWrappedException.map(col, this.resultSet::getBinaryStream);
    }

    public Reader getCharacterStream(String col) {
        return SQLWrappedException.map(col, this.resultSet::getCharacterStream);
    }

    public Reader getCharacterStream(int col) {
        return SQLWrappedException.map(col, this.resultSet::getCharacterStream);
    }

    public Reader getNCharacterStream(String col) {
        return SQLWrappedException.map(col, this.resultSet::getNCharacterStream);
    }

    public Reader getNCharacterStream(int col) {
        return SQLWrappedException.map(col, this.resultSet::getNCharacterStream);
    }

    public RowId getRowId(int col) {
        return SQLWrappedException.map(col, this.resultSet::getRowId);
    }

    public RowId getRowId(String col) {
        return SQLWrappedException.map(col, this.resultSet::getRowId);
    }

    public int getRow() {
        return SQLWrappedException.get(this.resultSet::getRow);
    }

    public LocalTime getTime(int col) {
        Time time = SQLWrappedException.map(col, this.resultSet::getTime);
        return NullSafe.safe(time::toLocalTime);
    }

    public LocalTime getTime(String col) {
        Time time = SQLWrappedException.map(col, this.resultSet::getTime);
        return NullSafe.safe(time::toLocalTime);
    }

    public LocalDate getDate(String col) {
        Date time = SQLWrappedException.map(col, this.resultSet::getDate);
        return NullSafe.safe(time::toLocalDate);
    }

    public LocalDate getDate(int col) {
        Date time = SQLWrappedException.map(col, this.resultSet::getDate);
        return NullSafe.safe(time::toLocalDate);
    }

    public LocalDateTime getDateTime(int col) {
        Timestamp time = SQLWrappedException.map(col, this.resultSet::getTimestamp);
        return NullSafe.safe(time::toLocalDateTime);
    }

    public LocalDateTime getDateTime(String col) {
        Timestamp time = SQLWrappedException.map(col, this.resultSet::getTimestamp);
        return NullSafe.safe(time::toLocalDateTime);
    }

    public boolean next() {
        return SQLWrappedException.get(this.resultSet::next);
    }
}

