/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.odoframework.sql.ColumnReference;
import net.odoframework.sql.SQLFunction;

public class ResultSetMapper<T>
implements SQLFunction<ResultSet, T> {
    private Function<ResultSet, T> instanceConstructor;
    private Map<ColumnReference, BiConsumer<T, ?>> setters;

    public ResultSetMapper(Function<ResultSet, T> instanceConstructor) {
        this.instanceConstructor = Objects.requireNonNull(instanceConstructor);
    }

    public ResultSetMapper(T instance) {
        this(() -> instance);
    }

    public ResultSetMapper(Supplier<T> instance) {
        this.instanceConstructor = rs -> instance.get();
    }

    public static <T> ResultSetMapper<T> into(Function<ResultSet, T> instanceConstructor) {
        return new ResultSetMapper<Function<ResultSet, T>>(instanceConstructor);
    }

    public static <T> ResultSetMapper<T> into(T instance) {
        return new ResultSetMapper<T>(instance);
    }

    public static <T> ResultSetMapper<T> into(Supplier<T> instance) {
        return new ResultSetMapper<T>(instance);
    }

    public ResultSetMapper<T> field(int columnReference, BiConsumer<T, ?> handler) {
        return this.field(ColumnReference.index(columnReference), handler);
    }

    public ResultSetMapper<T> field(String columnReference, BiConsumer<T, ?> handler) {
        return this.field(ColumnReference.name(columnReference), handler);
    }

    public ResultSetMapper<T> field(ColumnReference columnReference, BiConsumer<T, ?> handler) {
        if (this.setters == null) {
            this.setters = new LinkedHashMap();
        }
        this.setters.put(Objects.requireNonNull(columnReference), Objects.requireNonNull(handler));
        return this;
    }

    @Override
    public T apply(ResultSet value) throws SQLException {
        Object instance = this.instanceConstructor.apply(value);
        if (this.setters != null) {
            this.setters.forEach((k, v) -> {
                Object val = k.read(value);
                BiConsumer func = v;
                func.accept(instance, val);
            });
        }
        return instance;
    }
}

