/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.ResultSet;
import java.util.Objects;
import net.odoframework.beans.Binding;
import net.odoframework.sql.SQLUtils;
import net.odoframework.util.Strings;

public class ResultSetBinding<T, K>
implements Binding<T, K> {
    private final ResultSet resultSet;
    private final String column;

    public ResultSetBinding(ResultSet resultSet, String column) {
        this.resultSet = Objects.requireNonNull(resultSet, "resultSet is required");
        this.column = Strings.requireNotBlank(column, "column is required");
    }

    @Override
    public K get(T instance) {
        return (K)SQLUtils.getColumn(this.resultSet, this.column);
    }

    @Override
    public void set(T instance, K value) {
        SQLUtils.setColumn(this.resultSet, this.column, value);
    }
}

