/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.odoframework.util.ListBackedMap;
import net.odoframework.util.Strings;
import net.odoframework.util.TrackedMap;

public class Record {
    private TrackedMap<String, Object> row;
    private String table;
    private String[] idFields;
    private Map<String, List<Record>> children;

    public Record(String table, String ... primaryKeyFields) {
        this.table = Strings.requireNotBlank(table, "table is a required parameter").trim();
        this.idFields = primaryKeyFields;
        this.row = new TrackedMap(new ListBackedMap());
        this.children = new TrackedMap(new ListBackedMap());
    }

    public Record primaryKeyFields(String ... fields) {
        this.idFields = fields;
        return this;
    }

    public Map<String, ?> getKey() {
        if (this.idFields.length == 0) {
            throw new IllegalStateException("idFields has not been initialized");
        }
        ListBackedMap<String, Object> keyMap = new ListBackedMap<String, Object>();
        for (String s : this.idFields) {
            Object value = this.row.get(s);
            if (value == null) {
                throw new IllegalArgumentException("missing primary key field " + s);
            }
            keyMap.put(s, value);
        }
        return keyMap;
    }

    public Map<String, ?> getRow() {
        return Collections.unmodifiableMap(this.row);
    }

    public <K> K get(String field) {
        return (K)this.row.get(field);
    }

    public int getInt(String name) {
        return (Integer)this.get(name);
    }

    public long getLong(String name) {
        return (Long)this.get(name);
    }

    public boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public char getChar(String name) {
        return ((Character)this.get(name)).charValue();
    }

    public <K extends Enum<K>> K getEnum(String name, Class<K> enumType) {
        K val = this.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return Enum.valueOf(enumType, val.toString());
        }
        if (val instanceof Integer) {
            return (K)((Enum[])enumType.getEnumConstants())[(Integer)val];
        }
        throw new IllegalStateException(val.getClass().getName() + " cannot be converted to an enumeration");
    }

    public Record set(String field, Object value) {
        this.row.put(field, value);
        return this;
    }

    public Record remove(String field) {
        this.row.remove(field);
        return this;
    }

    public Record removeChild(String table) {
        this.children.remove(table);
        return this;
    }

    public Record addChild(String table, Record child) {
        if (!this.children.containsKey(table)) {
            this.children.put(table, new ArrayList());
        }
        this.children.get(table).add(child);
        return this;
    }

    public List<Record> getChildren(String table) {
        if (!this.children.containsKey(table)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children.get(table));
    }

    public String getTable() {
        return this.table;
    }

    public String[] getIdFields() {
        return this.idFields;
    }

    public Map<String, List<Record>> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        return this.row.equals(record.row) && this.table.equals(record.table) && this.idFields.equals(record.idFields) && this.children.equals(record.children);
    }

    public int hashCode() {
        return Objects.hash(this.row, this.table, this.idFields, this.children);
    }

    public String toString() {
        return this.table + "[" + this.getKey().toString() + "]";
    }
}

