/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import net.odoframework.sql.DBStatement;
import net.odoframework.sql.SQLWrappedException;

public class Query
implements AutoCloseable {
    private final DBStatement dbStatement;
    private final boolean closeConnection;
    private DataSource dataSource;
    private Connection conn;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public Query(DBStatement dbStatement, DataSource dataSource, boolean closeConnection) {
        this.dbStatement = Objects.requireNonNull(dbStatement);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.closeConnection = closeConnection;
    }

    private void createStatement(DBStatement sql, PreparedStatement statement) throws SQLException {
        Map<Integer, Object> bindings = sql.getBindings();
        if (!bindings.isEmpty()) {
            for (Map.Entry<Integer, Object> entry : bindings.entrySet()) {
                statement.setObject(entry.getKey(), entry.getValue());
            }
        }
    }

    public ResultSet getResultSet() {
        try {
            if (this.resultSet == null) {
                this.conn = this.dataSource.getConnection();
                this.preparedStatement = this.conn.prepareStatement(this.dbStatement.getSql());
                this.createStatement(this.dbStatement, this.preparedStatement);
                this.resultSet = this.preparedStatement.executeQuery();
            }
            return this.resultSet;
        }
        catch (SQLException e) {
            throw new SQLWrappedException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        if (this.closeConnection) {
            this.conn.close();
        }
    }
}

