/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.odoframework.sql.DBStatement;
import net.odoframework.util.Strings;

public abstract class BaseUpdateStatement
implements DBStatement {
    private final String table;
    private Map<String, Supplier<?>> fields;

    public BaseUpdateStatement(String table) {
        this.table = Strings.requireNotBlank(table, "table cannot be blank");
    }

    public void addField(String name, Supplier<?> value) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap();
        }
        this.fields.put(Strings.requireNotBlank(name, "name is a required parameter"), Objects.requireNonNull(value, "value is required"));
    }

    Map<String, Supplier<?>> getFields() {
        if (this.fields == null) {
            this.fields = new LinkedHashMap();
        }
        return this.fields;
    }

    @Override
    public Map<Integer, Object> getBindings() {
        if (this.fields == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, Object> items = new LinkedHashMap<Integer, Object>(this.fields.size() + 1);
        AtomicInteger cnt = new AtomicInteger(1);
        this.fields.values().forEach(it -> items.put(cnt.getAndIncrement(), it.get()));
        return items;
    }

    public String getTable() {
        return this.table;
    }
}

