/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.odoframework.util.Pair;

public class NumberCoercingConverter<T extends Number, K extends Number>
implements Function<T, K> {
    private static final Collection<Class<? extends Number>> NUMBERS = Arrays.asList(Byte.class, Short.class, Float.class, Integer.class, Long.class, Double.class, BigInteger.class, BigDecimal.class);
    private Class<K> target;

    public NumberCoercingConverter(Class<K> target) {
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public K apply(T t) {
        String targetName;
        if (t == null) {
            return null;
        }
        switch (targetName = this.target.getSimpleName().toLowerCase()) {
            case "byte": {
                return (K)Byte.valueOf(((Number)t).byteValue());
            }
            case "short": {
                return (K)Short.valueOf(((Number)t).shortValue());
            }
            case "integer": {
                return (K)Integer.valueOf(((Number)t).intValue());
            }
            case "float": {
                return (K)Float.valueOf(((Number)t).floatValue());
            }
            case "long": {
                return (K)Long.valueOf(((Number)t).longValue());
            }
            case "double": {
                return (K)Double.valueOf(((Number)t).doubleValue());
            }
            case "biginteger": {
                return (K)new BigInteger(t.toString());
            }
            case "bigdecimal": {
                return (K)new BigDecimal(t.toString());
            }
        }
        throw new IllegalStateException(targetName + " is not a supported number type");
    }

    public static Map<Pair<Class<?>, Class<?>>, Function<?, ?>> numberCoercions() {
        HashMap types = new HashMap();
        for (Class<? extends Number> number : NUMBERS) {
            for (Class<? extends Number> targetNumber : NUMBERS) {
                if (number.equals(targetNumber)) continue;
                types.put(new Pair<Class<? extends Number>, Class<? extends Number>>(number, targetNumber), new NumberCoercingConverter(targetNumber));
            }
        }
        return types;
    }
}

