/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans;

import java.util.Objects;
import java.util.function.Function;
import net.odoframework.beans.Binding;
import net.odoframework.beans.OneWayBinding;

public class TwoWayBinding<Source, SourceType, Target, TargetType>
extends OneWayBinding<Source, SourceType, Target, TargetType> {
    private Function<SourceType, TargetType> toTarget = src -> src;

    public TwoWayBinding(Binding<Source, SourceType> sourceBinding, Binding<Target, TargetType> targetBinding, Function<SourceType, TargetType> toTarget, Function<TargetType, SourceType> fromTarget) {
        super(sourceBinding, targetBinding, fromTarget);
        this.toTarget = Objects.requireNonNull(toTarget, "toTarget is a required parameter");
    }

    public TwoWayBinding(Binding<Source, SourceType> sourceBinding, Binding<Target, TargetType> targetBinding) {
        this(sourceBinding, targetBinding, src -> src, target -> target);
    }

    public TargetType bindTo(Source source, Target target) {
        Object sourceValue = this.sourceBinding.get(source);
        TargetType targetValue = this.toTarget.apply(sourceValue);
        this.targetBinding.set(target, targetValue);
        return targetValue;
    }
}

