/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.beans;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.beans.Binding;

public class PropertyBinding<T, K>
implements Binding<T, K> {
    protected final Function<T, K> getter;
    protected final BiConsumer<T, K> setter;

    public PropertyBinding(Function<T, K> getter, BiConsumer<T, K> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public PropertyBinding(Function<T, K> getter) {
        this(getter, null);
    }

    public PropertyBinding(BiConsumer<T, K> setter) {
        this(null, setter);
    }

    public static <T, K> Binding<T, K> binding(Function<T, K> getter, BiConsumer<T, K> setter) {
        if (getter == null && setter == null) {
            throw new IllegalArgumentException("You must have at least one null getter and setter");
        }
        return new PropertyBinding<T, K>(getter, setter);
    }

    public static <T, K> Binding<T, K> binding(BiConsumer<T, K> setter) {
        return new PropertyBinding<T, K>(null, setter);
    }

    public static <T, K> Binding<T, K> binding(Function<T, K> getter) {
        return new PropertyBinding<T, K>(getter, null);
    }

    @Override
    public K get(T instance) {
        return Objects.requireNonNull(this.getter, "no getter for this property binding").apply(Objects.requireNonNull(instance));
    }

    @Override
    public void set(T instance, K value) {
        Objects.requireNonNull(this.setter, "no setter for this property binding").accept(Objects.requireNonNull(instance), value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyBinding)) {
            return false;
        }
        PropertyBinding other = (PropertyBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function<T, K> this$getter = this.getGetter();
        Function<T, K> other$getter = other.getGetter();
        if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
            return false;
        }
        BiConsumer<T, K> this$setter = this.getSetter();
        BiConsumer<T, K> other$setter = other.getSetter();
        return !(this$setter == null ? other$setter != null : !this$setter.equals(other$setter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyBinding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<T, K> $getter = this.getGetter();
        result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
        BiConsumer<T, K> $setter = this.getSetter();
        result = result * 59 + ($setter == null ? 43 : $setter.hashCode());
        return result;
    }

    public Function<T, K> getGetter() {
        return this.getter;
    }

    public BiConsumer<T, K> getSetter() {
        return this.setter;
    }
}

